require ( "quest/butterflies/butterflies.lua" );

function set_module_2_flags()
	-- setup where napkin should be
	game:Set("first_time_napkin", 1);
	game:Set("got_napkin", 1);
	game:Set("got_map", 1);
	game:Set("napkin_find_snookums", 4);
	game:Set("napkin_need_dye_remover", 4);
	game:Set("napkin_check_with_betty", 4);
	game:Set("napkin_betty_needs_dye", 4);
	game:Set("napkin_red_bottle", 4);
	game:Set("napkin_dianes_window", 4);
	game:Set("napkin_check_with_walter", 4);
	game:Set("napkin_give_derek_coffee", 4);
	game:Set("napkin_give_diane_oil", 4);
	game:Set("napkin_give_betty_dye", 4);
	game:Set("napkin_check_supply_drawers", 4);
	game:Set("napkin_bring_dye_to_petspa", 4);
	game:Set("napkin_lure_snookums", 4);
	game:Set("napkin_need_dog_treats", 4);
	game:Set("napkin_got_dog_treats", 4);
	game:Set("napkin_give_walter_snookums", 4);
	
	-- Dress tasks
	game:Set("napkin_wedding_dress", 4);
	game:Set("napkin_check_with_bobbi", 4);
	game:Set("napkin_find_beads", 4);
	game:Set("napkin_fix_beadmachine", 4);
	game:Set("napkin_find_screwdriver", 4);
	game:Set("napkin_find_beadmachine_code", 4);
	game:Set("napkin_do_beadwork", 4);
	game:Set("napkin_need_beads", 4);
	game:Set("napkin_need_wirecutters", 4);
	game:Set("napkin_give_ethel_wirecutters", 4);
	game:Set("napkin_finish_beading", 4);
	game:Set("napkin_need_lace", 4);
	game:Set("napkin_beauty_curtains", 4);
	game:Set("napkin_use_pole", 4);
	game:Set("napkin_need_pole", 4);
	
	-- Butterfly tasks
	game:Set("napkin_collect_butterflies1", 4);
	game:Set("napkin_butterfly_bag", 4);
	
	-- butterflies
	mark_off_butterflies(1);
	game:Set( "butterflies_1", 1);
	
	-- purse
	game:Set("found_phone", 1);
	
	-- recycle machine
	game:Set("got_subway_token", 1);
	
	-- diner
	game:Set("found_phone", 1);
	game:Set("first_time_diner", 1);
	game:Set("cleaned_coffee_spill", 1);
	game:Set("diner_phone_ringing" , 1);
	
	-- florida st
	game:Set("florida_tutorial", 10);
	game:Set("got_red_dye", 1);
	game:Set("seen_bernie_with_suit", 1);
	game:Set("talked_to_greg_herb", 1);
	game:Set("got_butterflybag", 1);
	game:Set("diane_window_conv", 1);
	game:Set("first_time_talk_diane", 1);
	game:Set("looked_at_red_dye", 1);
	
	-- pet spa
	game:Set("first_time_pet_spa", 1);
	game:Set("first_time_talked_to_walter", 1);
	game:Set("told_walter_about_snookums", 1);
	game:Set("given_snookums_to_walter", 1);
	game:Set("given_dye_remover_to_walter", 1);
	game:Set("walter_asked_for_dye_remover", 1);
	game:Set("first_time_leave_pet_spa", 1);
	game:Set("got_wirecutters", 1);
	game:Set("looked_at_treats_in_pet_spa", 1);
	
	-- beauty salon
	game:Set("first_time_beauty_salon", 1);
	game:Set("given_dye_to_betty", 1);
	game:Set("got_dye_remover", 1);
	game:Set("got_curtains", 1);
	game:Set("clicked_curtains_in_beauty_salon", 1);
	game:Set("got_garment_pole", 1);
	game:Set("opened_beauty_salon_drawers", 1);
	
	-- dress shop
	game:Set("first_time_dress_shop", 1);
	game:Set("beadmachine_fixed", 1);
	game:Set("beadmachine_panel_open", 1);
	game:Set("beadmachine_has_beads", 0);
	game:Set("first_time_dress_panel", 1);
	game:Set("got_screwdriver", 1);
	game:Set("clicked_on_garment_pole", 1);
	game:Set("beads_found_in_dress_shop", 10);
	
	-- pet shop
	game:Set("first_time_pet_shop", 1);
	game:Set("got_dog_treat", 1);
	game:Set("clicked_on_dogtreats", 1);
	game:Set("talked_to_cassie", 1);
	
	-- spendalot 1
	game:Set("first_time_m1_spendalot1");
	game:Set("talked_to_ethel", 1);
	game:Set("got_beads_from_ethel", 1);
	game:Set("asked_ethel_for_beads", 1);
	
	-- spendalot 2
	game:Set("first_time_m1_spendalot2")
	game:Set("given_derek_coffee", 1);
	game:Set("talked_to_derek", 1);
	game:Set("got_oil_can", 1);
	game:Set("seen_snookums", 1);
	game:Set("got_snookums", 1);
	
	-- mini-games
	game:Set("mg_bead_activity_round", 3);
	game:Set("mg_bead_activity_num", 1);
	game:Set("beading_unlocked", 1);
	game:Set("mg_clothing_activity_round", 2);
	game:Set("mg_clothing_activity_num", 1);
	game:Set("clothing_unlocked", 1);
	game:Set("mg_package_activity_round", 2);
	game:Get("mg_package_activity_num", 1);
	game:Set("package_unlocked", 1);
	
	-- subway
	game:Set("first_time_subway", 1);
	game:Set("module_progress", 2);
	game:Set("cur_module", 2);
end

function set_module_3_flags()

	set_module_2_flags();
	
	-- setup where napkin should be
	
	-- bakery tasks
	game:Set("napkin_cake", 4);
	game:Set("napkin_check_with_stella", 4);
	game:Set("napkin_get_recipe", 4);
	game:Set("napkin_get_ingredients", 4);
	game:Set("napkin_get_eggs", 4);
	game:Set("napkin_use_eggs", 4);
	game:Set("napkin_get_cake_instructions", 4);
	
	-- farm tasks
	game:Set("napkin_check_farm", 4);
	game:Set("napkin_get_lugnuts", 4);
	game:Set("napkin_pass_chickenchorus", 4);
	game:Set("napkin_pass_chickenfield", 4);
	
	-- aerobics and girl sprout tasks
	game:Set("napkin_use_cake_instructions", 4);
	game:Set("napkin_pass_aerobics", 4);
	game:Set("napkin_info_cake_code", 4);
	game:Set("napkin_info_vcr", 4);
	game:Set("napkin_get_cookies", 4);
	game:Set("napkin_pass_girl_sprouts", 4);
	game:Set("napkin_use_cookies", 4);
	
	-- Butterfly tasks
	game:Set("napkin_collect_butterflies2", 4);
	game:Set("napkin_butterfly_bag", 4);
	
	-- butterflies
	mark_off_butterflies(2);
	game:Set( "butterflies_2", 1);
	
	-- bakery
	game:Set("first_time_bakery", 1);
	game:Set("unlocked_recipe_box", 1);
	game:Set("cake_first_attempt", 1);
	game:Set("talked_to_stella_about_eggs", 1);
	game:Set( "cake_delivered", 1 );
	game:Set("told_stella_found_eggs", 1);
	game:Set("told_stella_watched_tape", 1);
	game:Set("already_clicked_on_recipe_box", 1);
	game:Set("got_recipe", 1);
	game:Set("visited_kitchen", true);
	
	-- farm
	game:Set("first_time_farm", 1);
	game:Set("visited_farm", 1);
	
	-- fitness
	game:Set("completed_aerobics", 1);
	game:Set("first_time_fitness", 1);
	
	-- kitchen
	game:Set("kitchen_activity_tutorial", 1);
	game:Set("first_time_kitchen", 1);
	game:Set( "cake_done", 1 );
	game:Set( "got_video", 1 );
	
	-- m2 intersection
	game:Set("first_time_intersection2", 1);
	
	-- sizzle2
	game:Set("first_time_sizzle2", 1);
	game:Set("nuts_found_in_sizzle2", 10);
	game:Set("clicked_ernie", 1);
	game:Set("bus_paid", 1);
	game:Set("bus_fixed", 1);
	
	-- sunnyside
	game:Set("girl_sprout_money_on_street", 2);
	game:Set("first_time_talked_to_sprouts", 1);
	game:Set("first_time_sproutstand", 1);
	
	-- purse
	game:Set("found_ten_dollars_in_purse", 1);
	
	-- recycle machine
	game:Set("got_subway_token", 3);
	
	-- mini-games
	game:Set("mg_aerobics_activity_round", 2);
	game:Set("mg_aerobics_activity_num", 1);
	game:Set( "egg_count", 6 );
	game:Set("first_time_talked_to_hen", 1);
	game:Set("mg_chickenchorus_activity_round", 2);
	game:Set("mg_chickenchorus_activity_num", 1);
	game:Set("visited_chicken_chorus", 1);
	game:Set("chicken_chorus_unlocked", 1);
	game:Set("mg_chickenfield_activity_round", 2);
	game:Set("mg_chickenfield_activity_num", 1);
	game:Set("chicken_field_unlocked", 1);
	game:Set("triangle_unlocked", 1);
	game:Set("got_recipe", 1);
	game:Set("mg_trilock_activity_round", 2);
	game:Set("mg_trilock_activity_num", 1);
	
	-- subway
	game:Set("module_progress", 3);
	game:Set("cur_module", 3);
end


function mark_off_butterflies(module_num)
	local range_start = butterfly_range[module_num][1];
	local range_end = butterfly_range[module_num][2];
	local butterfly_count = game:Get("butterfly_count");
	
	for i = range_start, range_end do
		local capturedString = string.format("captured_butterfly_%03d", i);
		
		if game:Get(capturedString) ~= 1 then
			game:Set(capturedString, 1);
			butterfly_count = butterfly_count + 1;
		end
	end
	
	game:Set("butterfly_count", butterfly_count);
end
